/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.pather;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiomclientapi.pathers.BallShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ToolPatherMinRadius {
    private boolean realtimeUpdates;
    private final Offset[] ball;
    private final Offset[][] cardinalHalfBalls;
    private final Offset[][][] bicardinalBallSlices;
    private final Position2FloatMap minDistances = new Position2FloatMap(-1.0f);
    @Nullable
    private final ChunkedBooleanRegion simplePreview;
    @Nullable
    private final ChunkedBooleanRegion simplePreviewBall;
    private boolean closed = false;
    private class_2338 lastPosition = null;
    private class_2338 currentPosition = null;
    private class_243 lastLookDirection = null;

    public ToolPatherMinRadius(int radius, boolean realtimeUpdates, BallShape ballShape) {
        int i;
        int j;
        this.realtimeUpdates = realtimeUpdates;
        if (realtimeUpdates) {
            this.simplePreview = null;
            this.simplePreviewBall = null;
        } else {
            this.simplePreview = new ChunkedBooleanRegion();
            this.simplePreviewBall = new ChunkedBooleanRegion();
        }
        radius = Math.max(1, radius);
        ArrayList<Offset> sphere = new ArrayList<Offset>();
        List cardinalHalfSpheres = List.of(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
        ArrayList bicardinalSphereSlices = new ArrayList();
        for (int i2 = 0; i2 < class_2350.values().length; ++i2) {
            ArrayList list = new ArrayList();
            for (j = 0; j < class_2350.values().length; ++j) {
                list.add(new ArrayList());
            }
            bicardinalSphereSlices.add(list);
        }
        float radiusSq = ((float)radius + 0.5f) * ((float)radius + 0.5f);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    float distanceSq = ballShape.distanceSq(x, y, z);
                    if (!(distanceSq <= radiusSq)) continue;
                    if (this.simplePreviewBall != null) {
                        this.simplePreviewBall.add(x, y, z);
                    }
                    Offset offset = new Offset(x, y, z, (float)Math.sqrt(distanceSq));
                    sphere.add(offset);
                    for (class_2350 direction : class_2350.values()) {
                        int z2;
                        int y2;
                        int x2 = x + direction.method_10163().method_10263();
                        float distanceSq2 = ballShape.distanceSq(x2, y2 = y + direction.method_10163().method_10264(), z2 = z + direction.method_10163().method_10260());
                        if (!(distanceSq2 >= distanceSq)) continue;
                        ((List)cardinalHalfSpheres.get(direction.method_10146())).add(offset);
                        List cardinalSphereSlices = (List)bicardinalSphereSlices.get(direction.method_10146());
                        for (class_2350 direction2 : class_2350.values()) {
                            int z3;
                            int y3;
                            int x3 = x - direction2.method_10163().method_10263();
                            float distanceSq3 = ballShape.distanceSq(x3, y3 = y - direction2.method_10163().method_10264(), z3 = z - direction2.method_10163().method_10260());
                            if (!(distanceSq3 >= distanceSq)) continue;
                            ((List)cardinalSphereSlices.get(direction2.method_10146())).add(offset);
                        }
                    }
                }
            }
        }
        this.ball = sphere.toArray(new Offset[0]);
        this.cardinalHalfBalls = new Offset[6][];
        for (i = 0; i < 6; ++i) {
            this.cardinalHalfBalls[i] = ((List)cardinalHalfSpheres.get(i)).toArray(new Offset[0]);
        }
        this.bicardinalBallSlices = new Offset[6][6][];
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 6; ++j) {
                this.bicardinalBallSlices[i][j] = ((List)((List)bicardinalSphereSlices.get(i)).get(j)).toArray(new Offset[0]);
            }
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.simplePreview != null) {
            this.simplePreview.close();
        }
        if (this.simplePreviewBall != null) {
            this.simplePreviewBall.close();
        }
    }

    public void renderPreview(class_4184 camera, long time, class_4587 matrices, Matrix4f projection, int effects) {
        if (this.simplePreview != null && this.simplePreviewBall != null) {
            class_2338 offset;
            this.simplePreview.render(camera, class_243.field_1353, matrices, projection, time, effects);
            if (this.currentPosition != null) {
                offset = this.currentPosition;
            } else if (this.lastPosition != null) {
                offset = this.lastPosition;
            } else {
                return;
            }
            this.simplePreviewBall.render(camera, class_243.method_24954((class_2382)offset), matrices, projection, time, effects);
        }
    }

    public void update(PathConsumer consumer) {
        class_746 entity = class_310.method_1551().field_1724;
        if (entity == null || entity != class_310.method_1551().method_1560()) {
            return;
        }
        class_243 lookDirection = null;
        if (EditorUI.isActive()) {
            if (EditorUI.isMovingCamera()) {
                return;
            }
            lookDirection = EditorUI.getMouseLookVector();
        } else if (class_310.method_1551().method_1560() != null) {
            lookDirection = class_310.method_1551().method_1560().method_5720();
        }
        if (lookDirection == null) {
            return;
        }
        class_243 start = entity.method_33571();
        boolean includeFluids = Tool.defaultIncludeFluids();
        if (this.lastLookDirection == null || this.lastPosition == null) {
            RayCaster.RaycastResult raycastResult = RayCaster.raycast(entity.method_37908(), start.method_46409(), lookDirection.method_46409(), false, includeFluids, true);
            if (raycastResult != null) {
                this.lastLookDirection = lookDirection;
                this.lastPosition = raycastResult.getBlockPos();
                for (Offset offset : this.ball) {
                    int x = offset.x() + this.lastPosition.method_10263();
                    int y = offset.y() + this.lastPosition.method_10264();
                    int z = offset.z() + this.lastPosition.method_10260();
                    this.minDistances.put(x, y, z, offset.distanceFromCenter);
                    if (this.realtimeUpdates) {
                        consumer.accept(x, y, z, offset.distanceFromCenter);
                        continue;
                    }
                    if (this.simplePreview == null) continue;
                    this.simplePreview.add(x, y, z);
                }
            }
        } else {
            double dot = this.lastLookDirection.method_1026(lookDirection);
            double angleChange = Math.toDegrees(Math.acos(dot));
            int steps = 1;
            if (angleChange > 1.0) {
                steps = (int)Math.ceil(angleChange);
            }
            for (int i = 1; i <= steps; ++i) {
                float f = (float)i / (float)steps;
                class_243 look = this.lastLookDirection.method_35590(lookDirection, (double)f);
                RayCaster.RaycastResult raycastResult = RayCaster.raycast(entity.method_37908(), start.method_46409(), look.method_46409(), false, includeFluids, true);
                if (raycastResult == null || raycastResult.getBlockPos().equals((Object)this.lastPosition)) continue;
                class_2338.class_2339 pos = new class_2338.class_2339();
                Rasterization3D.dda(this.currentPosition == null ? this.lastPosition : this.currentPosition, raycastResult.getBlockPos(), (x1, y1, z1) -> {
                    pos.method_10103(x1, y1, z1);
                    if (pos.equals((Object)this.currentPosition)) {
                        return;
                    }
                    if (this.currentPosition == null) {
                        if (!pos.equals((Object)this.lastPosition)) {
                            this.currentPosition = pos.method_10062();
                        }
                        return;
                    }
                    float centerDistance = this.minDistances.get(this.currentPosition.method_10263(), this.currentPosition.method_10264(), this.currentPosition.method_10260());
                    if (centerDistance != 0.0f) {
                        int dz;
                        int dy;
                        int dx = this.currentPosition.method_10263() - this.lastPosition.method_10263();
                        class_2350 first = this.getDirectionFromDelta(dx, dy = this.currentPosition.method_10264() - this.lastPosition.method_10264(), dz = this.currentPosition.method_10260() - this.lastPosition.method_10260());
                        if (first == null) {
                            throw new FaultyImplementationError();
                        }
                        dx = pos.method_10263() - this.currentPosition.method_10263();
                        class_2350 second = this.getDirectionFromDelta(dx, dy = pos.method_10264() - this.currentPosition.method_10264(), dz = pos.method_10260() - this.currentPosition.method_10260());
                        if (second == null) {
                            throw new FaultyImplementationError();
                        }
                        for (Offset offset : this.bicardinalBallSlices[first.method_10146()][second.method_10146()]) {
                            int z;
                            int y;
                            int x = offset.x() + this.currentPosition.method_10263();
                            float oldDistance = this.minDistances.get(x, y = offset.y() + this.currentPosition.method_10264(), z = offset.z() + this.currentPosition.method_10260());
                            if (!(oldDistance < 0.0f) && !(offset.distanceFromCenter < oldDistance)) continue;
                            this.minDistances.put(x, y, z, offset.distanceFromCenter);
                            if (this.realtimeUpdates) {
                                consumer.accept(x, y, z, offset.distanceFromCenter);
                                continue;
                            }
                            if (this.simplePreview == null) continue;
                            this.simplePreview.add(x, y, z);
                        }
                    }
                    this.lastPosition = this.currentPosition;
                    this.currentPosition = pos.method_10062();
                });
            }
            this.lastLookDirection = lookDirection;
            if (this.realtimeUpdates && this.currentPosition != null) {
                int dz;
                int dy;
                int dx = this.currentPosition.method_10263() - this.lastPosition.method_10263();
                class_2350 direction = this.getDirectionFromDelta(dx, dy = this.currentPosition.method_10264() - this.lastPosition.method_10264(), dz = this.currentPosition.method_10260() - this.lastPosition.method_10260());
                if (direction == null) {
                    throw new FaultyImplementationError();
                }
                for (Offset offset : this.cardinalHalfBalls[direction.method_10146()]) {
                    int z;
                    int y;
                    int x = offset.x() + this.currentPosition.method_10263();
                    float oldDistance = this.minDistances.get(x, y = offset.y() + this.currentPosition.method_10264(), z = offset.z() + this.currentPosition.method_10260());
                    if (!(oldDistance < 0.0f) && !(offset.distanceFromCenter < oldDistance)) continue;
                    this.minDistances.put(x, y, z, offset.distanceFromCenter);
                    consumer.accept(x, y, z, offset.distanceFromCenter);
                }
                this.currentPosition = null;
            }
        }
    }

    public void finish(PathConsumer consumer) {
        if (this.realtimeUpdates) {
            return;
        }
        this.realtimeUpdates = true;
        if (this.currentPosition != null) {
            int dz;
            int dy;
            int dx = this.currentPosition.method_10263() - this.lastPosition.method_10263();
            class_2350 direction = this.getDirectionFromDelta(dx, dy = this.currentPosition.method_10264() - this.lastPosition.method_10264(), dz = this.currentPosition.method_10260() - this.lastPosition.method_10260());
            if (direction == null) {
                throw new FaultyImplementationError();
            }
            for (Offset offset : this.cardinalHalfBalls[direction.method_10146()]) {
                int z;
                int y;
                int x = offset.x() + this.currentPosition.method_10263();
                float oldDistance = this.minDistances.get(x, y = offset.y() + this.currentPosition.method_10264(), z = offset.z() + this.currentPosition.method_10260());
                if (!(oldDistance < 0.0f) && !(offset.distanceFromCenter < oldDistance)) continue;
                this.minDistances.put(x, y, z, offset.distanceFromCenter);
            }
            this.currentPosition = null;
        }
        this.minDistances.forEachEntry(consumer::accept);
    }

    @Nullable
    private class_2350 getDirectionFromDelta(int dx, int dy, int dz) {
        if (dx == 0) {
            if (dy == 0) {
                if (dz == 0) {
                    return null;
                }
                if (dz == 1) {
                    return class_2350.field_11035;
                }
                if (dz == -1) {
                    return class_2350.field_11043;
                }
                throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
            }
            if (dz == 0) {
                if (dy == 1) {
                    return class_2350.field_11036;
                }
                if (dy == -1) {
                    return class_2350.field_11033;
                }
                throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
            }
            throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
        }
        if (dy == 0 && dz == 0) {
            if (dx == 1) {
                return class_2350.field_11034;
            }
            if (dx == -1) {
                return class_2350.field_11039;
            }
            throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
        }
        throw new FaultyImplementationError("Not a direction: dx=" + dx + " dy=" + dy + " dz=" + dz);
    }

    private record Offset(int x, int y, int z, float distanceFromCenter) {
    }

    @FunctionalInterface
    public static interface PathConsumer {
        public void accept(int var1, int var2, int var3, float var4);
    }
}

